<?php
/* --------------------------------------------------------------
   UserConfigurationKey.php 2020-02-13
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\UserConfiguration\Model;

use Gambio\Admin\UserConfiguration\Interfaces\UserConfigurationKey as UserConfigurationKeyInterface;
use Webmozart\Assert\Assert;

/**
 * Class UserConfigurationKey
 *
 * @package Gambio\Admin\UserConfiguration\Model
 */
class UserConfigurationKey implements UserConfigurationKeyInterface
{
    /**
     * @var string
     */
    private $value;
    
    
    /**
     * UserConfigurationKey constructor.
     *
     * @param string $value
     */
    private function __construct(string $value)
    {
        $this->value = $value;
    }
    
    
    /**
     * @param string $value
     *
     * @return UserConfigurationKey
     */
    public static function create(string $value): UserConfigurationKey
    {
        Assert::notWhitespaceOnly($value, 'User configuration key can not be empty.');
        
        return new self($value);
    }
    
    
    /**
     * @return string
     */
    public function value(): string
    {
        return $this->value;
    }
}